require( "scripts/style.lua" );


kImageY = 5;
kButtonX = 10;
kButtonY = 5;
kButtonSpacing = 28;
kTextX = 0;
kTextY = 5;

kHeaderY = 100;
kLevelX = 100;
kRatingX = 300;
kStatusX = 500;

HeaderFont = {
	standardFont,
	24,
	BorderColor
};

EntryFont = {
	standardFont,
	16,
	BorderColor
};

SlotButtonGraphics = {
	"scripts/leveleditor/customer_a",
	"scripts/leveleditor/customer_b",
	"scripts/leveleditor/customer_c"
};


function GameSlot(n)
	return Group {

			
		Button
		{
			name = 'gamebutton_'..n,
			x = kButtonX, y = kButtonY+kButtonSpacing*(n-1),
			graphics=SlotButtonGraphics,
			font = EntryFont,
			label = '',
			command =
				function()
					ModalReturn(GetCustomerName(n-1));
					PopModal("scripts/leveleditor/customers.lua");
				end
		},
	}
end

function GameSlots()
	t= {}
	for i = 1,5 do
		table.insert(t,GameSlot(i))
	end
	return Group(t)
end




MakeDialog
{
	FillWindow
	{
		x=200,y=150,w=400,h=300,
		r = 0.5,
		g = 0.5,
		b = 0.5,
			
		Bitmap
		{
			image="scripts/leveleditor/customer_back",
			x = kCenter,
			y = kCenter,
			
			SetStyle(ScrolledWindowStyle);
			CustomerWindow
			{
				name = "gamescroller",
				x = 0,
				y = 0,
				w = kMax,
				h = kMax,
				SetStyle(DefaultStyle);
				GameSlots(),
			},
			
		},
		
        
        
        Button
		{
			x=50,
			y=250,
			font = StandardButtonFont,
			graphics = SolidButtonGraphics,
			name="delete",
			label="le_delete",
			type = kPush,
			command=
				function()
					ModalReturn('');
					PopModal("scripts/leveleditor/customers.lua");
				end
		},
		
		
		Button
		{
			x=200,
			y=250,
			font = StandardButtonFont,
			graphics = SolidButtonGraphics,
			name="back",
			label="back",
			type = kPush,
			command=
				function()
					PopModal("scripts/leveleditor/customers.lua");
				end
		},
		
			
	},
	
};
